# -*- coding: utf-8 -*-

from requests import get, put, post, delete
from shutil import rmtree

import re
import sys
import json
import xbmc
import xbmcvfs
import xbmcgui
import urllib
import urllib.parse
import os

from . import control

from socket import create_connection,gethostbyname
try:
	host = gethostbyname("www.google.com")
	s = create_connection((host, 80), 2)
except:
	control.dialog.ok(control.addon().getAddonInfo('name'),"Can't Connect to the Internet. Check your internet connection and reset Kodi. (E07)")
	sys.exit()
	pass

class myPlayer(xbmc.Player):
	def __init__(self, *args, **kwargs):
		xbmc.Player.__init__(self, *args, **kwargs)	 
		self.imdb = 0
		self.season = 0
		self.episode = 0
		self.type = 0
		self.totalTime = 0
		self.currentTime = 0
		self.resumeTime = 0
		self.headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'Authorization': 'Bearer '+control.addon().getSetting('token')}
		
	def onPlayBackStarted(self):
		while not self.isPlayingVideo():
			xbmc.sleep(100)
		self.totalTime = self.getTotalTime()
		if (int(self.resumeTime)!=999999 and int(self.resumeTime)>10):
			self.seekTime(int(self.resumeTime))
	
	def onPlayBackEnded(self):
		self.videoEnd()
			
	def onPlayBackStopped(self):
		self.videoEnd()

	def monitorPlayer(self):
		for i in range(0, 240):
			if self.isPlayingVideo(): break
			xbmc.sleep(1000)

		while self.isPlayingVideo():
			try:
				self.currentTime = self.getTime()
			except:
				pass
			xbmc.sleep(2000)
	
	def videoEnd(self):
		try:
			if self.totalTime>0:
				if (self.currentTime/self.totalTime) > 0.9:
					if self.type=="movie":
						put(control.myaddon_link+'history/movie/finish/%s'%(self.imdb), headers=self.headers)
					elif self.type=="episode":
						put(control.myaddon_link+'history/tvshow/finish/%s/%s/%s'%(self.imdb,int(self.season),int(self.episode)), headers=self.headers)
				elif (self.currentTime/self.totalTime) > 0.1:
					if self.type=="movie":
						put(control.myaddon_link+'history/movie/position/%s/%s'%(self.imdb,int(self.currentTime)), headers=self.headers)
					elif self.type=="episode":
						put(control.myaddon_link+'history/tvshow/position/%s/%s/%s/%s'%(self.imdb,int(self.season),int(self.episode),int(self.currentTime)), headers=self.headers)
				else:		
					if self.type=="movie":
						put(control.myaddon_link+'history/movie/position/%s/%s'%(self.imdb,0), headers=self.headers)
					elif self.type=="episode":
						put(control.myaddon_link+'history/tvshow/position/%s/%s/%s/%s'%(self.imdb,int(self.season),int(self.episode),0), headers=self.headers)
		except:
			pass
		xbmc.executebuiltin('Container.Refresh')
		
class myAddon():
	def __init__(self, *args, **kwargs):
		self.imdb = 0
		self.season = 0
		self.episode = 0
		self.headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'Authorization': 'Bearer '+control.addon().getSetting('token')}

	def moviePlay(self,imdb,title,poster,plot,resumeTime):
		stream = control.myaddon_link+'stream/%s/%s/movie/%s'%(control.addon().getSetting('email'),control.addon().getSetting('password'),imdb)
		link = stream+'|'+urllib.parse.urlencode({'Keep-Alive':'True','Connection':'keep-alive'})
		
		meta = {"title":title,'mediatype': 'movie','plot': plot,'title': title}

		item = control.item()
		item.setArt({'icon': poster, 'thumb': poster, 'poster': poster, 'tvshow.poster': poster, 'season.poster': poster})
		item.setInfo(type='Video', infoLabels = meta)
		item.setProperty('IMDBNumber', imdb)
		
		self.Player = myPlayer()
		self.Player.imdb = imdb
		self.Player.type = "movie"
		self.Player.resumeTime = resumeTime
		
		self.Player.play(link,item)
		#control.resolve(int(sys.argv[1]), True, item)
		self.Player.monitorPlayer()
		
	def episodePlay(self,imdb,season,episode,title,poster,plot,resumeTime):
		stream = control.myaddon_link+'stream/%s/%s/tvshow/%s/%s/%s'%(control.addon().getSetting('email'),control.addon().getSetting('password'),imdb,season,episode)
		link = stream+'|'+urllib.parse.urlencode({'Keep-Alive':'True','Connection':'keep-alive'})
		
		if poster == None or poster == '' or poster == 'N/A': poster = '0'
		#poster = poster.encode('utf-8')
		
		meta = {"title":title,"season":season,"episode":episode,'mediatype': 'episode','plot': plot,'title': title}

		item = control.item()
		item.setArt({'icon': poster, 'thumb': poster, 'poster': poster, 'tvshow.poster': poster, 'season.poster': poster})
		item.setInfo(type='Video', infoLabels = meta)
		item.setProperty("IMDBNumber", imdb)
		item.setProperty("season", season)
		item.setProperty("episode", episode)

		self.Player = myPlayer()
		self.Player.imdb = imdb
		self.Player.type = "episode"
		self.Player.season = season
		self.Player.episode = episode
		self.Player.resumeTime = resumeTime
		
		self.Player.play(link,item)
		#control.resolve(int(sys.argv[1]), True, item)
		self.Player.monitorPlayer()
		
	def setAdvanceBuffer(self):
		AdvFile = xbmcvfs.translatePath(os.path.join('special://profile', 'advancedsettings.xml'))
		if os.path.exists(AdvFile):
			i = control.dialog.yesno(control.addon().getAddonInfo('name'),"Setting advance buffer setting","will remove current advancedsettings.xml. Continue?")
		else:
			i = 1
		if not i == 0:
			try:
				xml = []
				xml.append("<advancedsettings>\n")
				xml.append('\t<cache>\n')
				xml.append('\t\t<buffermode>1</buffermode>\n')
				xml.append('\t\t<memorysize>139460608</memorysize>\n')
				xml.append('\t\t<readfactor>20</readfactor>\n')
				xml.append('\t</cache>\n')
				xml.append('\t<network>\n')
				xml.append('\t\t<curlclienttimeout>10</curlclienttimeout>\n')
				xml.append('\t\t<curllowspeedtime>30</curllowspeedtime> \n')
				xml.append('\t\t<curlretries>2</curlretries>\n')
				xml.append('\t</network>\n')
				xml.append("</advancedsettings>")
				outF = open(AdvFile, 'wb')
				outF.write(bytes("".join(xml), 'utf8'))
				outF.close()
				
				control.dialog.ok(control.addon().getAddonInfo('name'), "Buffer advance setting approve","Reset kodi to take change take effect")
			except: pass

	def cleanCache(self):
		i = control.dialog.yesno(control.addon().getAddonInfo('name'),"Are you sure you want to delete","all your addon setting ?")
		if not i == 0:
			try:
				rmtree(control.dataPath)
				control.dialog.ok(control.addon().getAddonInfo('name'), "Addon setting deleted")
			except: pass
	
	def tvguide(self):
		xbmc.executebuiltin('Dialog.Close(busydialog)')
		xbmc.executebuiltin('ActivateWindow(TVGuide)')

	def logout(self):
		headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'X-API-VERSION': 'v2', 'Authorization': 'Bearer '+control.addon().getSetting('token')}
		response = get(control.myaddon_link+"logout", headers=headers)
		data = json.loads(response.text)

		control.addon().setSetting('account', "No Account")
		control.addon().setSetting('paid', "false")
		control.addon().setSetting('expire', "0")
		control.addon().setSetting('token',"0")
		control.addon().openSettings()

	def login(self,hide):
		if not hide:
			xbmc.executebuiltin('Notification('+control.addon().getAddonInfo('name')+',"Please wait, checking account info.", {0}, {1})'.format(2500,os.path.join( control.addonPath ,"icon.png")))

		headers = {'Content-Type': 'application/json', 'Accept': 'application/json'}
		loginData = {'username': control.addon().getSetting('email'), 'password': control.addon().getSetting('password')}
		response = post(control.myaddon_link+"login", data=json.dumps(loginData), headers=headers)

		data = json.loads(response.text)
		if ("success" in data and data["success"]==0) or "errors" in data or "data" not in data:
			control.dialog.ok(control.addon().getAddonInfo('name')+" Error", data["message"])
			control.addon().openSettings()
			return

		if "token" in data["data"]:
			control.addon().setSetting('token', data["data"]["token"])
		headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'Authorization': 'Bearer '+control.addon().getSetting('token')}
		response = get(control.myaddon_link+'user', headers=headers)
		data = json.loads(response.text)

		if "account_name" not in data["data"]:
			if not hide:
				control.dialog.ok(control.addon().getAddonInfo('name')+" Error", data["message"])
			return

		if "account_name" in data["data"]:
			if control.addon().getSetting('expire')!=data["data"]["account_name"]:
				control.addon().setSetting('account', data["data"]["account_name"])

		if "expiration_date" in data["data"]:
			if control.addon().getSetting('expire')!=data["data"]["expiration_date"]:
				control.addon().setSetting('expire', data["data"]["expiration_date"][0:10])

		if control.addon().getSetting('account')!="No Account":
			control.addon().setSetting('paid', "true")

		if not hide:
			control.addon().openSettings()

	def movieMyList(self,imdb,param):
		if int(param) == 1:
			respond = post(control.myaddon_link+'favorite/movie/%s'%(imdb), headers=self.headers)
		else:
			respond = delete(control.myaddon_link+'favorite/movie/%s'%(imdb), headers=self.headers)
		jsonT = json.loads(respond.text.decode("utf-8"))
		if "message" in jsonT:
			control.dialog.ok(control.addon().getAddonInfo('name'), "%s"%(jsonT["message"]))

	def tvMyList(self,imdb,param):
		if int(param) == 1:
			respond = post(control.myaddon_link+'favorite/tvshow/%s'%(imdb), headers=self.headers)
		else:
			respond = delete(control.myaddon_link+'favorite/tvshow/%s'%(imdb), headers=self.headers)
		jsonT = json.loads(respond.text.decode("utf-8"))
		if "message" in jsonT:
			control.dialog.ok(control.addon().getAddonInfo('name'), "%s"%(jsonT["message"]))

	def liveMyList(self,epg_id,param):
		if int(param) == 1:
			respond = post(control.myaddon_link+'favorite/livetv/%s'%(epg_id), headers=self.headers)
		else:
			respond = delete(control.myaddon_link+'favorite/livetv/%s'%(epg_id), headers=self.headers)
		jsonT = json.loads(respond.text.decode("utf-8"))
		if "message" in jsonT:
			control.dialog.ok(control.addon().getAddonInfo('name'), "%s"%(jsonT["message"]))
	
	def sportMyList(self,sport_id,param):
		if int(param) == 1:
			respond = post(control.myaddon_link+'event/favorite/%s'%(sport_id), headers=self.headers)
		else:
			respond = delete(control.myaddon_link+'event/favorite/%s'%(sport_id), headers=self.headers)
		jsonT = json.loads(respond.text.decode("utf-8"))
		if "message" in jsonT:
			control.dialog.ok(control.addon().getAddonInfo('name'), "%s"%(jsonT["message"]))
