# -*- coding: utf-8 -*-
import xbmc
import xbmcgui
from requests import get
from ..modules import control
import sys
import re
import json
import urllib
from urllib.parse import urljoin
import datetime

class sports:
    def __init__(self):
        self.list = []
        self.headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'X-API-VERSION': 'v2', 'Authorization': 'Bearer '+control.addon().getSetting('token')}

    def search(self):
        try:
            control.idle()
            
            t = control.lang(32010)
            k = control.keyboard('', t);
            k.doModal()
            q = k.getText()
            if (q == None or q == ''):
                return
            
            response = get(control.myaddon_link+'event/search/%s'%q, headers=self.headers)
            data = json.loads(response.text)
            if "data" not in data:
                from ..modules import myaddon
                myaddon.myAddon().login(1)
                return 0
            self.sportItems(data['data'])
        except:
            return

    def sportItems(self,sports):
        for sport in sports:
            try:
                title = sport['title']
            except:
                title = ''
            try:
                logo_url = sport['category']['logo_url']
            except:
                logo_url = ''
            try:
                edate = sport['event_date'].split('T')
                desc = edate[0]
            except:
                desc = ''
            try:
                self.list.append({'id': str(sport['id']),'title':desc + "   " + title,'desc':desc,'url': control.myaddon_link+'stream/%s/%s/event/%s'%(control.addon().getSetting('email'),control.addon().getSetting('password'),sport['id']),'poster': logo_url})
            except:
                print("####### ERROR Getting List from Server: {0} {1}".format(str(sport['id']), sport))
                pass
        try:
            self.list = sorted(self.list, key=lambda k: k['desc'], reverse=True)
        except:
            pass
        self.sportDirectory(self.list)
        return self.list
        
    def sportsCategory(self, category_id):
        try:
            response = get(control.myaddon_link+'event/files/%s/0/1000'%category_id, headers=self.headers)
            data = json.loads(response.text)
            if "data" not in data:
                from ..modules import myaddon
                myaddon.myAddon().login(1)
                return 0
            self.sportItems(data['data'])
        except:
            pass

    def sportDirectory(self, items):
        if items == None or len(items) == 0: control.idle() ; sys.exit()
        
        sysaddon = sys.argv[0]
        syshandle = int(sys.argv[1])
        addonPoster, addonBanner = control.addonPoster(), control.addonBanner()
        addonFanart = control.addonFanart()
        
        response = get(control.myaddon_link + 'event/favorite/list/0/1000', headers=self.headers)
        favoriteJson = json.loads(response.text)
        favoriteArray = {}
        if "data" in favoriteJson:
            if favoriteJson["data"] is not None:
                for fav in favoriteJson["data"]:
                    favoriteArray[fav] = 1
        
        for i in items:
            try:
                label = "{0}".format(i['title'])
                poster = i['poster']
                banner = '0'
                id = i['id']
                item = control.item(label=label)
                item.addStreamInfo('video', { 'width':1920 ,'height' : 1080 })
                item.setArt({'icon': poster, 'thumb': poster, 'poster': poster, 'banner': banner})
                
                contextMenuItems = []
                if id in favoriteArray:
                    contextMenuItems.append(('Remove from My List', 'XBMC.RunPlugin(%s?action=sportMyList&param=0&sport_id=%s)' % (sysaddon,id)))
                else:
                    contextMenuItems.append(('Add to My List', 'XBMC.RunPlugin(%s?action=sportMyList&param=1&sport_id=%s)' % (sysaddon,id)))
                    
                item.addContextMenuItems(contextMenuItems, replaceItems=True)
                item.setInfo(type='Video', infoLabels = {"Title": '{0}'.format(label), "Plot": '{0}'.format(i['desc'])})
                control.addItem(handle=syshandle, url=i['url'], listitem=item, isFolder=False)
            except:
                pass
        
        control.content(syshandle, 'sports')
        control.directory(syshandle, cacheToDisc=True)

    def sportsMyList(self):
        response = get(control.myaddon_link + 'event/favorite/list/0/1000', headers=self.headers)
        favoriteJson = json.loads(response.text)

        favoriteArray = []
        if "data" in favoriteJson:
            if len(favoriteJson["data"]) > 0:
                for fav in favoriteArray["data"]:
                    response = get(control.myaddon_link+'event/%s'%fav, headers=self.headers)
                    info = json.loads(response.text)
                    if "data" in info:
                        favoriteArray.append(info["data"][0])
        self.sportItems(favoriteArray)
